<?php
require_once __DIR__ . '/lib/auth.php';
require_once __DIR__ . '/lib/db.php';
require_once __DIR__ . '/lib/helpers.php';
require_once __DIR__ . '/lib/csrf.php';



require_login();
if (!(can('admin') || can('moderate'))) {
  http_response_code(403); echo "Only admin/moderator can moderate."; exit;
}
require_once __DIR__ . '/lib/demo.php';
demo_guard(); // blocks POST in demo mode

function ensure_results_table(){
  $sql = "CREATE TABLE IF NOT EXISTS results (
            id INT NOT NULL AUTO_INCREMENT,
            user_id INT NOT NULL,
            course_id INT NOT NULL,
            assessor_id INT DEFAULT NULL,
            decision ENUM('C','NYC') NOT NULL,
            feedback TEXT NULL,
            created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            verified_at DATETIME NULL,
            moderated_at DATETIME NULL,
            PRIMARY KEY (id),
            UNIQUE KEY uq_res_user_course (user_id, course_id)
          ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
  db()->exec($sql);
}
ensure_results_table();

if (isset($_POST['moderate_id'])) {
  $id = (int)$_POST['moderate_id'];
  // Only moderate verified results
  $st = db()->prepare("UPDATE results SET moderated_at=NOW() WHERE id=? AND verified_at IS NOT NULL");
  $st->execute([$id]);
  header('Location: '.url('moderate_result.php')); exit;
}

$rows = db()->query("
  SELECT r.id, r.user_id, r.course_id, r.decision, r.feedback, r.created_at, r.verified_at,
         u.name AS learner, c.title AS course
    FROM results r
    JOIN users u ON u.id=r.user_id
    JOIN courses c ON c.id=r.course_id
   WHERE r.verified_at IS NOT NULL AND r.moderated_at IS NULL
   ORDER BY r.created_at DESC
")->fetchAll();

include __DIR__ . '/templates/header.php';
?>
<h1>Moderate Results</h1>
<?php if (!$rows): ?>
  <p class="small">Nothing to moderate.</p>
<?php else: ?>
  <table class="mini">
    <tr><th>Learner</th><th>Course</th><th>Decision</th><th>Feedback</th><th>Verified</th><th></th></tr>
    <?php foreach($rows as $r): ?>
      <tr>
        <td><?=e($r['learner'])?></td>
        <td><?=e($r['course'])?></td>
        <td><?=e($r['decision'])?></td>
        <td><?=e($r['feedback'])?></td>
        <td><?=e($r['verified_at'])?></td>
        <td>
          <form method="post" onsubmit="return confirm('Mark as moderated (locked)?');">
              <?php csrf_field(); ?>
            <input type="hidden" name="moderate_id" value="<?=$r['id']?>">
            <button class="btn btn-small">Moderate (Lock)</button>
          </form>
        </td>
      </tr>
    <?php endforeach; ?>
  </table>
<?php endif; ?>
<?php include __DIR__ . '/templates/footer.php'; ?>
