<?php
require_once __DIR__ . '/lib/auth.php';
require_once __DIR__ . '/lib/db.php';
require_once __DIR__ . '/lib/helpers.php';

// Simple DB helper functions (DRY)
if (!function_exists('qv')) {
  function qv($sql, $params = []) {
    $s = db()->prepare($sql);
    $s->execute($params);
    return $s->fetch();
  }
}
if (!function_exists('qa')) {
  function qa($sql, $params = []) {
    $s = db()->prepare($sql);
    $s->execute($params);
    return $s->fetchAll();
  }
}
if (!function_exists('qn')) {
  function qn($sql, $params = []) {
    try {
      $r = qv($sql,$params);
      return (int)array_values($r ?? [0])[0];
    } catch(Throwable $e){
      return 0;
    }
  }
}

require_login();
$u = current_user();

$rows = qa("
  SELECT c.cert_code, c.issued_at, co.title AS course
  FROM certificates c
  JOIN courses co ON co.id=c.course_id
  WHERE c.user_id=?
  ORDER BY c.issued_at DESC
", [$u['id']]);

include __DIR__ . '/templates/header.php';
?>
<h1>My Certificates</h1>
<?php if (!$rows): ?>
  <p class="small">No certificates issued yet.</p>
<?php else: ?>
  <table class="mini">
    <tr><th>Code</th><th>Course</th><th>Issued</th><th>Actions</th></tr>
    <?php foreach($rows as $r): ?>
      <tr>
        <td><?= e($r['cert_code']) ?></td>
        <td><?= e($r['course']) ?></td>
        <td><?= e($r['issued_at']) ?></td>
        <td>
          <a class="btn btn-small" href="<?= e(url('certificate_view.php?code='.$r['cert_code'])) ?>">View</a>
          <a class="btn btn-small btn-outline" href="<?= e(url('certificate_pdf.php?code='.$r['cert_code'])) ?>" target="_blank">PDF</a>
        </td>
      </tr>
    <?php endforeach; ?>
  </table>
<?php endif; ?>
<?php include __DIR__ . '/templates/footer.php'; ?>
