<?php
// qr.php — proxy QR as PNG for Dompdf & web
// Usage: /lmis/qr.php?data=https://your-verify-url
// NOTE: keep it simple; no caching here for now (KISS).
$data = $_GET['data'] ?? '';
if ($data === '') {
  http_response_code(400);
  header('Content-Type: text/plain');
  echo 'Missing data';
  exit;
}
$url = 'https://api.qrserver.com/v1/create-qr-code/?size=180x180&data=' . urlencode($data);

$png = @file_get_contents($url);
if ($png === false) {
  http_response_code(502);
  header('Content-Type: text/plain');
  echo 'QR service error';
  exit;
}

header('Content-Type: image/png');
header('Cache-Control: public, max-age=86400');
echo $png;
