<?php
// qr_logo.php — generate a QR PNG with AIT logo overlay (center)
// Usage: /lmis/qr_logo.php?data=https://verify-link&logo=https://.../ait_logo.png

$data = $_GET['data'] ?? '';
$logo = $_GET['logo'] ?? '';
if ($data === '') {
  http_response_code(400);
  header('Content-Type: text/plain');
  echo 'Missing data';
  exit;
}

// Fetch base QR (reliable external service)
$qrUrl = 'https://api.qrserver.com/v1/create-qr-code/?size=360x360&data=' . urlencode($data);
$qrPng = @file_get_contents($qrUrl);
if ($qrPng === false) {
  http_response_code(502);
  header('Content-Type: text/plain');
  echo 'QR service error';
  exit;
}

// If GD not available or no logo param, just return the QR
if (!function_exists('imagecreatefromstring') || $logo === '') {
  header('Content-Type: image/png');
  header('Cache-Control: public, max-age=86400');
  echo $qrPng;
  exit;
}

// Try to overlay logo
$qrImg = @imagecreatefromstring($qrPng);
$logoBin = @file_get_contents($logo);
if ($qrImg === false || $logoBin === false) {
  header('Content-Type: image/png');
  header('Cache-Control: public, max-age=86400');
  echo $qrPng; // fallback: plain QR
  exit;
}

$logoImg = @imagecreatefromstring($logoBin);
if ($logoImg === false) {
  header('Content-Type: image/png');
  header('Cache-Control: public, max-age=86400');
  echo $qrPng;
  exit;
}

// Compute overlay size (about 28% of QR width)
$qrW = imagesx($qrImg); $qrH = imagesy($qrImg);
$targetW = (int)round($qrW * 0.28);
$targetH = (int)round(imagesy($logoImg) * ($targetW / imagesx($logoImg)));

// Resample logo
$logoRes = imagecreatetruecolor($targetW, $targetH);
imagesavealpha($logoRes, true);
$trans = imagecolorallocatealpha($logoRes, 0,0,0,127);
imagefill($logoRes, 0,0, $trans);
imagecopyresampled($logoRes, $logoImg, 0,0, 0,0, $targetW, $targetH, imagesx($logoImg), imagesy($logoImg));

// Center overlay
$dstX = (int)(($qrW - $targetW) / 2);
$dstY = (int)(($qrH - $targetH) / 2);

// Paste with alpha
imagecopy($qrImg, $logoRes, $dstX, $dstY, 0,0, $targetW, $targetH);

// Output PNG
header('Content-Type: image/png');
header('Cache-Control: public, max-age=86400');
imagepng($qrImg);
imagedestroy($qrImg);
imagedestroy($logoImg);
imagedestroy($logoRes);
