<?php
require_once __DIR__ . '/lib/auth.php';
require_once __DIR__ . '/lib/db.php';
require_once __DIR__ . '/lib/helpers.php';
// ✅ ADD THIS LINE: load the CSRF helper
require_once __DIR__ . '/lib/csrf.php';

require_login();
if (!(can('admin') || can('grade'))) {
  http_response_code(403); echo "Only admin/assessor can record results."; exit;
}
require_once __DIR__ . '/lib/demo.php';
demo_guard(); // blocks POST in demo mode


function ensure_results_table(){
  $sql = "CREATE TABLE IF NOT EXISTS results (
            id INT NOT NULL AUTO_INCREMENT,
            user_id INT NOT NULL,
            course_id INT NOT NULL,
            assessor_id INT DEFAULT NULL,
            decision ENUM('C','NYC') NOT NULL,
            feedback TEXT NULL,
            created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            verified_at DATETIME NULL,
            moderated_at DATETIME NULL,
            PRIMARY KEY (id),
            UNIQUE KEY uq_res_user_course (user_id, course_id),
            KEY idx_res_user (user_id),
            KEY idx_res_course (course_id),
            KEY idx_res_assessor (assessor_id)
          ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
  db()->exec($sql);
}
ensure_results_table();

$msg=''; $err='';

// 2) When the form is submitted (POST), first verify CSRF token
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  // ✅ This line checks the hidden token. If missing/wrong, it stops the request safely.
  verify_csrf_or_die();
  $user_id   = (int)($_POST['user_id'] ?? 0);
  $course_id = (int)($_POST['course_id'] ?? 0);
  $decision  = $_POST['decision'] ?? '';
  $feedback  = trim($_POST['feedback'] ?? '');

  if ($user_id<=0 || $course_id<=0 || !in_array($decision,['C','NYC'],true)) {
    $err = "Please choose learner, course, and decision.";
  } else {
    // insert or update (upsert) using unique key
    $sql = "INSERT INTO results (user_id,course_id,assessor_id,decision,feedback,created_at)
            VALUES (?,?,?,?,?,NOW())
            ON DUPLICATE KEY UPDATE
              assessor_id=VALUES(assessor_id),
              decision=VALUES(decision),
              feedback=VALUES(feedback),
              created_at=VALUES(created_at)";
    $st = db()->prepare($sql);
    $st->execute([$user_id,$course_id,current_user()['id'],$decision,$feedback]);
    $msg = "Result recorded.";
  }
}

$learners = db()->query("SELECT id,name,email FROM users WHERE role='learner' ORDER BY name")->fetchAll();
$courses  = db()->query("SELECT id,title FROM courses ORDER BY title")->fetchAll();

include __DIR__ . '/templates/header.php';
?>
<h1>Record Result (Assessor)</h1>
<?php if($msg): ?><div class="alert alert-ok"><?=e($msg)?></div><?php endif; ?>
<?php if($err): ?><div class="alert alert-error"><?=e($err)?></div><?php endif; ?>

<form method="post" class="form-card">
  <?php csrf_field(); ?>
  <label class="field">
    <span class="field__label">Learner</span>
    <select name="user_id" class="field__input" required>
      <option value="">-- choose learner --</option>
      <?php foreach($learners as $L): ?>
        <option value="<?=$L['id']?>"><?=e($L['name'])?> (<?=e($L['email'])?>)</option>
      <?php endforeach; ?>
    </select>
  </label>

  <label class="field">
    <span class="field__label">Course</span>
    <select name="course_id" class="field__input" required>
      <option value="">-- choose course --</option>
      <?php foreach($courses as $C): ?>
        <option value="<?=$C['id']?>"><?=e($C['title'])?></option>
      <?php endforeach; ?>
    </select>
  </label>

  <fieldset class="field">
    <span class="field__label">Decision</span>
    <label><input type="radio" name="decision" value="C" required> Competent (C)</label>
    &nbsp;&nbsp;
    <label><input type="radio" name="decision" value="NYC" required> Not Yet Competent (NYC)</label>
  </fieldset>

  <label class="field">
    <span class="field__label">Feedback (optional)</span>
    <textarea name="feedback" class="field__input" rows="4" placeholder="Key strengths, gaps, and next steps"></textarea>
  </label>

  <div class="form__actions">
    <button class="btn btn-primary" type="submit">Save Result</button>
    <a class="btn btn-outline" href="<?=e(url('dashboard.php'))?>">Back</a>
  </div>
</form>
<?php include __DIR__ . '/templates/footer.php'; ?>
