<?php
// /lmis/register.php — Individual or Company Admin signup (verification + doc)
ini_set('display_errors',1); error_reporting(E_ALL);

require_once __DIR__ . '/lib/auth.php';
require_once __DIR__ . '/lib/db.php';
require_once __DIR__ . '/lib/helpers.php';
require_once __DIR__ . '/lib/csrf.php';
require_once __DIR__ . '/lib/mail.php';

if (is_logged_in()) redirect('dashboard.php');

// sticky vars
$err=''; $msg='';
$name  = trim($_POST['name']  ?? '');
$email = trim($_POST['email'] ?? '');
$phone = trim($_POST['phone'] ?? '');
$acct  = $_POST['acct_type'] ?? 'individual'; // 'individual' | 'company_admin'
$comp  = trim($_POST['company_name'] ?? '');
$regno = trim($_POST['company_reg']  ?? '');

if ($_SERVER['REQUEST_METHOD']==='POST') {
  verify_csrf_or_die();
  $p1 = $_POST['password'] ?? '';
  $p2 = $_POST['password2'] ?? '';

  if ($name==='') $err='Full name is required.';
  if (!$err && !filter_var($email,FILTER_VALIDATE_EMAIL)) $err='Valid email is required.';
  if (!$err && strlen($p1)<8) $err='Password must be at least 8 characters.';
  if (!$err && $p1!==$p2)     $err='Passwords do not match.';
  if (!$err && $acct==='company_admin' && $comp==='') $err='Please enter your company name.';
  if (!$err && $acct==='company_admin' && $regno==='') $err='Please enter your company registration number.';

  // If company admin, file must be present
  $docTmpPath = null; $docRelPath = null;
  if (!$err && $acct==='company_admin') {
    if (empty($_FILES['reg_doc']['name'])) {
      $err = 'Please upload the Company Registration Certificate (PDF/JPG/PNG).';
    } else {
      // basic file checks
      $okExt = ['pdf','jpg','jpeg','png'];
      $ext = strtolower(pathinfo($_FILES['reg_doc']['name'], PATHINFO_EXTENSION));
      if (!in_array($ext,$okExt,true)) {
        $err = 'Allowed file types: PDF, JPG, PNG.';
      } elseif ($_FILES['reg_doc']['error'] !== UPLOAD_ERR_OK) {
        $err = 'Upload failed. Please try again.';
      } elseif ($_FILES['reg_doc']['size'] > 8*1024*1024) {
        $err = 'File too large (max 8MB).';
      }
      if (!$err) {
        // where to save
        $root  = realpath(__DIR__);
        $dirAbs = $root . '/storage/company_docs';
        if (!is_dir($dirAbs)) @mkdir($dirAbs, 0775, true);

        $fn = 'regdoc_'.time().'_'.bin2hex(random_bytes(4)).'.'.$ext;
        $abs = $dirAbs.'/'.$fn;
        $rel = '/lmis/storage/company_docs/'.$fn;

        if (!@move_uploaded_file($_FILES['reg_doc']['tmp_name'], $abs)) {
          $err = 'Server could not store the file.';
        } else {
          $docRelPath = $rel;
        }
      }
    }
  }

  // Duplicate email
  if (!$err) {
    $st = db()->prepare("SELECT id FROM users WHERE email=? LIMIT 1");
    $st->execute([$email]);
    if ($st->fetch()) $err='That email is already registered.';
  }

  if (!$err) {
    $hash = password_hash($p1, PASSWORD_DEFAULT);
    $token = bin2hex(random_bytes(16)); // email verify token

    // create user (email not verified yet)
    $uIns = db()->prepare("
      INSERT INTO users (name,email,password_hash,role,phone,email_verify_token,created_at)
      VALUES (?,?,?,?,?, ?, NOW())
    ");
    $uIns->execute([$name,$email,$hash,'learner',$phone?:null,$token]);
    $uid = (int)db()->lastInsertId();

    // if company admin: create company (pending) + map user
    if ($acct==='company_admin') {
      $cIns = db()->prepare("
        INSERT INTO companies (name,reg_no,status,verification_doc_path,created_by,created_at)
        VALUES (?,?,?,?,?,NOW())
      ");
      $cIns->execute([$comp,$regno,'pending',$docRelPath,$uid]);
      $cid = (int)db()->lastInsertId();

      $mIns = db()->prepare("INSERT INTO company_user_map (company_id,user_id,role) VALUES (?,?, 'company_rep')");
      $mIns->execute([$cid,$uid]);
    }

    // send verify email
    $verifyUrl = full_url('verify_email.php?token='.$token);
    $ok = send_mail_simple(
      $email,
      'Verify your email — Africa In Training',
      '<p>Hello '.e($name).',</p>
       <p>Please verify your email to activate your account:</p>
       <p><a href="'.e($verifyUrl).'">'.e($verifyUrl).'</a></p>
       <p>Thank you,<br>Africa In Training</p>'
    );

    // log them in (so they see their dashboard), but company pages remain blocked until approved
    login_user($uid);
    $msg = $ok ? 'We sent a verification link to your email.' : 'Account created. (Email send failed — please contact support to verify.)';

    if ($acct==='company_admin') {
      // land on company settings (will show “Pending approval” banner)
      redirect('company/settings.php');
    } else {
      redirect('dashboard.php');
    }
  }
}

include __DIR__ . '/templates/header.php';
?>
<h1>Create your account</h1>
<?php if ($err): ?><div class="alert alert-error"><?= e($err) ?></div><?php endif; ?>
<?php if ($msg): ?><div class="alert alert-ok"><?= e($msg) ?></div><?php endif; ?>

<form method="post" class="form-card" style="max-width:700px;" enctype="multipart/form-data" novalidate>
  <?php csrf_field(); ?>

  <div class="grid-2">
    <label class="field">
      <span class="field__label">Full name</span>
      <input class="field__input" name="name" value="<?= e($name) ?>" required>
    </label>
    <label class="field">
      <span class="field__label">Phone (optional)</span>
      <input class="field__input" name="phone" value="<?= e($phone) ?>" placeholder="+27 ...">
    </label>
  </div>

  <div class="grid-2">
    <label class="field">
      <span class="field__label">Email</span>
      <input class="field__input" type="email" name="email" value="<?= e($email) ?>" required>
    </label>
    <label class="field">
      <span class="field__label">Password</span>
      <input class="field__input" type="password" name="password" required>
    </label>
  </div>

  <label class="field">
    <span class="field__label">Confirm password</span>
    <input class="field__input" type="password" name="password2" required>
  </label>

  <fieldset class="field" style="margin-top:10px;">
    <span class="field__label">Account type</span>
    <div class="chips">
      <label class="chip">
        <input type="radio" name="acct_type" value="individual" <?= $acct==='company_admin'?'':'checked' ?>> Individual (learner)
      </label>
      <label class="chip">
        <input type="radio" name="acct_type" value="company_admin" <?= $acct==='company_admin'?'checked':'' ?>> I am a company admin
      </label>
    </div>

    <div id="company-fields" style="margin-top:10px; display: <?= $acct==='company_admin'?'block':'none' ?>;">
      <div class="grid-2">
        <label class="field">
          <span class="field__label">Company name</span>
          <input class="field__input" name="company_name" value="<?= e($comp) ?>" placeholder="e.g. Super Logistics (Pty) Ltd">
        </label>
        <label class="field">
          <span class="field__label">Registration number</span>
          <input class="field__input" name="company_reg" value="<?= e($regno) ?>" placeholder="e.g. 20xx/xxxxxx/xx">
        </label>
      </div>
      <label class="field">
        <span class="field__label">Upload company registration certificate (PDF/JPG/PNG)</span>
        <input class="field__input" type="file" name="reg_doc" accept=".pdf,.jpg,.jpeg,.png">
      </label>
      <div class="small muted">We’ll review this. While pending, company features are not accessible.</div>
    </div>
  </fieldset>

  <div class="form__actions">
    <button class="btn btn-primary" type="submit">Create account</button>
    <a class="btn btn-outline" href="<?= e(url('login.php')) ?>">I already have an account</a>
  </div>

  <p class="small" style="margin-top:8px;">
    By continuing, you agree to our
    <a href="<?= e(url('policies/Privacy-Policy.md')) ?>" target="_blank">Privacy Policy</a>
    and
    <a href="<?= e(url('policies/Code-of-Conduct.md')) ?>" target="_blank">Code of Conduct</a>.
  </p>
</form>

<script>
  (function(){
    const radios = document.querySelectorAll('input[name="acct_type"]');
    const box = document.getElementById('company-fields');
    radios.forEach(r => r.addEventListener('change', () => {
      box.style.display = (document.querySelector('input[name="acct_type"]:checked').value === 'company_admin') ? 'block' : 'none';
    }));
  })();
</script>

<?php include __DIR__ . '/templates/footer.php'; ?>
