<?php
// results.php — Assessor/Admin queues (schema-safe)
require_once __DIR__ . '/lib/auth.php';
require_once __DIR__ . '/lib/db.php';
require_once __DIR__ . '/lib/helpers.php';

require_login();
if (!(can('grade') || can('admin'))) { http_response_code(403); echo "Forbidden"; exit; }

/* ---- helpers ---- */
function qa($sql, $p=[]){ $s=db()->prepare($sql); $s->execute($p); return $s->fetchAll(); }
function has_table($t){
  try { db()->query("SELECT 1 FROM `$t` LIMIT 1"); return true; }
  catch(Throwable $e){ return false; }
}
function has_col($t,$c){
  try{ $st=db()->prepare("SHOW COLUMNS FROM `$t` LIKE ?"); $st->execute([$c]); return (bool)$st->fetch(); }
  catch(Throwable $e){ return false; }
}

/* ---- flags ---- */
$hasSubs    = has_table('submissions');
$hasResults = has_table('results');
$hasCerts   = has_table('certificates');

$tab = $_GET['tab'] ?? 'pending';
$tab = in_array($tab,['pending','nyc','issue'],true) ? $tab : 'pending';

include __DIR__ . '/templates/header.php';
?>
<h1>Assessment Queue</h1>

<div class="chips" style="margin-bottom:10px;">
  <a class="chip" href="<?=e(url('results.php?tab=pending'))?>">Pending</a>
  <a class="chip" href="<?=e(url('results.php?tab=nyc'))?>">NYC</a>
  <a class="chip" href="<?=e(url('results.php?tab=issue'))?>">Issue Certificates</a>
</div>

<?php
/* ---- TAB: Pending ---- */
if ($tab === 'pending') {
  echo "<h2 class='panel__title'>Pending POEs</h2><div class='panel'><div class='panel__body'>";
  if (!$hasSubs) {
    echo "<p class='small'>No <code>submissions</code> table found.</p>";
  } else {
    // If submissions.status exists, show only submitted/needs_review, else show all
    if (has_col('submissions','status')) {
      $rows = qa("
        SELECT s.id, s.user_id, s.course_id, u.name AS learner, c.title AS course,
               DATE_FORMAT(s.created_at,'%Y-%m-%d') AS d, s.status
          FROM submissions s
          JOIN users u   ON u.id=s.user_id
          JOIN courses c ON c.id=s.course_id
         WHERE s.status IN ('submitted','needs_review')
         ORDER BY s.created_at DESC
         LIMIT 200
      ");
    } else {
      // fallback: all submissions (you can refine later)
      $rows = qa("
        SELECT s.id, s.user_id, s.course_id, u.name AS learner, c.title AS course,
               COALESCE(DATE_FORMAT(s.created_at,'%Y-%m-%d'),'') AS d
          FROM submissions s
          JOIN users u   ON u.id=s.user_id
          JOIN courses c ON c.id=s.course_id
         ORDER BY s.id DESC
         LIMIT 200
      ");
    }

    if (!$rows) {
      echo "<p class='small'>Nothing pending.</p>";
    } else {
      echo "<table class='mini'><tr><th>Learner</th><th>Course</th><th>Date</th><th></th></tr>";
      foreach($rows as $r){
        echo "<tr>
          <td>".e($r['learner'])."</td>
          <td>".e($r['course'])."</td>
          <td>".e($r['d'])."</td>
          <td>
            <a class='btn btn-small' href='".e(url('grade.php?id='.$r['id']))."'>Grade</a>
            <a class='btn btn-small btn-outline' href='".e(url('record_result.php?user_id='.$r['user_id'].'&course_id='.$r['course_id']))."'>Record C/NYC</a>
          </td>
        </tr>";
      }
      echo "</table>";
    }
  }
  echo "</div></div>";
}

/* ---- TAB: NYC ---- */
if ($tab === 'nyc') {
  echo "<h2 class='panel__title'>NYC (Needs Verification)</h2><div class='panel'><div class='panel__body'>";
  if (!$hasResults) {
    echo "<p class='small'>No <code>results</code> table found.</p>";
  } else {
    if (has_col('results','verified_at')) {
      $rows = qa("
        SELECT r.id, r.user_id, r.course_id, r.feedback,
               u.name AS learner, c.title AS course,
               DATE_FORMAT(r.created_at,'%Y-%m-%d') AS d
          FROM results r
          JOIN users u ON u.id=r.user_id
          JOIN courses c ON c.id=r.course_id
         WHERE r.decision='NYC' AND r.verified_at IS NULL
         ORDER BY r.created_at DESC
         LIMIT 200
      ");
    } else {
      // if no verified_at, list all NYC
      $rows = qa("
        SELECT r.id, r.user_id, r.course_id, r.feedback,
               u.name AS learner, c.title AS course,
               DATE_FORMAT(r.created_at,'%Y-%m-%d') AS d
          FROM results r
          JOIN users u ON u.id=r.user_id
          JOIN courses c ON c.id=r.course_id
         WHERE r.decision='NYC'
         ORDER BY r.created_at DESC
         LIMIT 200
      ");
    }

    if (!$rows) {
      echo "<p class='small'>No NYC awaiting verification.</p>";
    } else {
      echo "<table class='mini'><tr><th>Learner</th><th>Course</th><th>Feedback</th><th>Created</th><th></th></tr>";
      foreach($rows as $r){
        echo "<tr>
          <td>".e($r['learner'])."</td>
          <td>".e($r['course'])."</td>
          <td>".e($r['feedback'])."</td>
          <td>".e($r['d'])."</td>
          <td>
            <a class='btn btn-small' href='".e(url('verify_result.php'))."'>Verify queue</a>
          </td>
        </tr>";
      }
      echo "</table>";
    }
  }
  echo "</div></div>";
}

/* ---- TAB: Issue Certificates ---- */
if ($tab === 'issue') {
  echo "<h2 class='panel__title'>Ready to Issue Certificates</h2><div class='panel'><div class='panel__body'>";
  if (!$hasResults || !$hasCerts) {
    echo "<p class='small'>Missing <code>results</code> or <code>certificates</code> table.</p>";
  } else {
    if (has_col('results','verified_at')) {
      $rows = qa("
        SELECT r.user_id, r.course_id, u.name AS learner, c.title AS course
          FROM results r
          JOIN users u   ON u.id=r.user_id
          JOIN courses c ON c.id=r.course_id
         WHERE r.decision='C' AND r.verified_at IS NOT NULL
           AND NOT EXISTS (
             SELECT 1 FROM certificates cc
              WHERE cc.user_id=r.user_id AND cc.course_id=r.course_id
           )
         ORDER BY u.name, c.title
         LIMIT 200
      ");
    } else {
      // no verified_at -> treat all C without certificate as issuable
      $rows = qa("
        SELECT r.user_id, r.course_id, u.name AS learner, c.title AS course
          FROM results r
          JOIN users u   ON u.id=r.user_id
          JOIN courses c ON c.id=r.course_id
         WHERE r.decision='C'
           AND NOT EXISTS (
             SELECT 1 FROM certificates cc
              WHERE cc.user_id=r.user_id AND cc.course_id=r.course_id
           )
         ORDER BY u.name, c.title
         LIMIT 200
      ");
    }

    if (!$rows) {
      echo "<p class='small'>No results are ready for issuing.</p>";
    } else {
      echo "<table class='mini'><tr><th>Learner</th><th>Course</th><th></th></tr>";
      foreach($rows as $r){
        // You might already have a script to issue certificates. Replace target if needed.
        $issueUrl = url('certificate_issue.php?user_id='.$r['user_id'].'&course_id='.$r['course_id']);
        echo "<tr>
          <td>".e($r['learner'])."</td>
          <td>".e($r['course'])."</td>
          <td>
            <a class='btn btn-small' href='".e($issueUrl)."'>Issue Certificate</a>
          </td>
        </tr>";
      }
      echo "</table>";
    }
  }
  echo "</div></div>";
}

include __DIR__ . '/templates/footer.php';

/* require_once __DIR__ . '/lib/auth.php';
require_once __DIR__ . '/lib/policy.php';
require_once __DIR__ . '/lib/db.php';
require_once __DIR__ . '/lib/helpers.php';
require_once __DIR__ . '/lib/cert.php';
require_once __DIR__ . '/lib/tracking.php';

require_login();
require_ability('grade'); // only assessors/moderators/admins

// 1) Load courses for the dropdown
$courses = db()->query("SELECT id,title FROM courses ORDER BY title")->fetchAll();
$course_id = (int)($_GET['course_id'] ?? 0);

// 2) If a course is selected, load enrollments + latest submission per learner
$rows = [];
if ($course_id){
  $sql = "
    SELECT u.id AS user_id, u.name, u.email,
           s.id AS submission_id, s.result, s.verified, s.created_at, s.grade, s.filename
    FROM enrolments e
    JOIN users u ON u.id = e.user_id
    LEFT JOIN submissions s ON s.user_id = e.user_id AND s.course_id = e.course_id
    WHERE e.course_id = ?
    GROUP BY u.id
    ORDER BY u.name ASC
  ";
  $st = db()->prepare($sql);
  $st->execute([$course_id]);
  $rows = $st->fetchAll();
}

// 3) Handle updates (POST)
$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST'){
  $course_id = (int)($_POST['course_id'] ?? 0);
  if ($course_id <= 0){ $msg = "Pick a course first."; }
  else{
    // We expect arrays: user_id[], result_USERID, verified_USERID
    foreach (($_POST['user_id'] ?? []) as $uid){
      $uid = (int)$uid;
      $result = $_POST['result_'.$uid] ?? ''; // 'C' or 'NYC' or ''
      $verified = isset($_POST['verified_'.$uid]) ? 1 : 0;

      // Update the learner's latest submission row (create one if none)
      // First find a submission
      $g = db()->prepare("SELECT id FROM submissions WHERE user_id=? AND course_id=? ORDER BY id DESC LIMIT 1");
      $g->execute([$uid, $course_id]);
      $sub = $g->fetch();

      if (!$sub){
        // Make a placeholder submission row so we can store result/verified
        $ins = db()->prepare("INSERT INTO submissions (user_id, course_id, filename, graded, grade, result, verified) VALUES (?,?,?,?,?,?,?)");
        $ins->execute([$uid, $course_id, '', 1, null, $result ?: null, $verified]);
        $submission_id = db()->lastInsertId();
      } else {
        $submission_id = (int)$sub['id'];
        $upd = db()->prepare("UPDATE submissions SET graded=1, result=?, verified=? WHERE id=?");
        $upd->execute([$result ?: null, $verified, $submission_id]);
      }

      audit('result.update', ['user_id'=>$uid, 'course_id'=>$course_id, 'submission_id'=>$submission_id, 'result'=>$result, 'verified'=>$verified]);

      // If PASS (C) AND Verified → issue certificate automatically
      if ($result === 'C' && $verified === 1){
        $cert = issue_certificate($uid, $course_id);
        // (Optional) Save a PDF copy to disk here by calling certificate_pdf.php internally,
        // or just let users download on demand. Keeping it on-demand is simpler and cheaper.
      }
    }
    $msg = "Saved results.";
    // Reload list
    header('Location: '.url('results.php?course_id='.$course_id.'&msg='.urlencode($msg)));
    exit;
  }
}

// message banner
$banner = $_GET['msg'] ?? $msg;

// HTML
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Results & Verification</title>
<style>
table { border-collapse: collapse; width:100%; }
td,th { border:1px solid #ccc; padding:6px; }
</style>
</head>
<body>
<?php include __DIR__ . '/templates/header.php'; ?>
<h2>Results & Verification</h2>
<?php if($banner): ?><p style="color:green;"><?=e($banner)?></p><?php endif; ?>

<form method="get">
  <label>Pick course:
    <select name="course_id" onchange="this.form.submit()">
      <option value="">-- choose --</option>
      <?php foreach($courses as $c): ?>
        <option value="<?=$c['id']?>" <?= $course_id===$c['id']?'selected':'' ?>><?=e($c['title'])?></option>
      <?php endforeach; ?>
    </select>
  </label>
</form>

<?php if($course_id && $rows): ?>
<form method="post">
  <input type="hidden" name="course_id" value="<?=$course_id?>">
  <table>
    <tr>
      <th>Learner</th>
      <th>Email</th>
      <th>Last Submission</th>
      <th>Result (C/NYC)</th>
      <th>Verified</th>
      <th>Certificate</th>
    </tr>
    <?php foreach($rows as $r): ?>
      <tr>
        <td><?=e($r['name'])?></td>
        <td><?=e($r['email'])?></td>
        <td><?= $r['submission_id'] ? ('#'.$r['submission_id'].' '.e($r['created_at'])) : '—' ?></td>
        <td>
          <select name="result_<?=$r['user_id']?>">
            <option value="" <?=(!$r['result'] ? 'selected':'')?>>--</option>
            <option value="C" <?=($r['result']==='C'?'selected':'')?>>C</option>
            <option value="NYC" <?=($r['result']==='NYC'?'selected':'')?>>NYC</option>
          </select>
        </td>
        <td>
          <input type="checkbox" name="verified_<?=$r['user_id']?>" <?=($r['verified']? 'checked':'')?>>
        </td>
        <td>
          <?php
          // Show link to certificate if exists
          $cst = db()->prepare("SELECT cert_code FROM certificates WHERE user_id=? AND course_id=? ORDER BY id DESC LIMIT 1");
          $cst->execute([$r['user_id'], $course_id]);
          $cert = $cst->fetch();
          if ($cert){
            $code = $cert['cert_code'];
            echo '<a href="'.url('certificate_pdf.php?code='.urlencode($code)).'">PDF</a> | ';
            echo '<a href="'.url('verify.php?code='.urlencode($code)).'">Verify</a>';
          } else {
            echo '—';
          }
          ?>
        </td>
      </tr>
      <input type="hidden" name="user_id[]" value="<?=$r['user_id']?>">
    <?php endforeach; ?>
  </table>
  <p><button type="submit">Save All</button></p>
</form>
<?php elseif($course_id): ?>
  <p>No enrolled learners yet.</p>
<?php endif; ?>

<?php include __DIR__ . '/templates/footer.php'; ?>
</body>
</html> */
