<?php
// settings_provider.php — Admin-only page to manage provider profile used across LMIS & Certificates.
ini_set('display_errors',1); error_reporting(E_ALL);

require_once __DIR__ . '/lib/auth.php';
require_once __DIR__ . '/lib/db.php';
require_once __DIR__ . '/lib/helpers.php';
require_once __DIR__ . '/lib/settings.php';
require_once __DIR__ . '/lib/csrf.php';
require_once __DIR__ . '/lib/demo.php';

require_login();
if (!can('admin')) { http_response_code(403); echo "Admins only."; exit; }
demo_guard(); // blocks POST in demo mode

$msg=''; $err='';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  verify_csrf_or_die();

  // Basics
  $provider_name      = trim($_POST['provider_name']      ?? '');
  $provider_address   = trim($_POST['provider_address']   ?? '');
  $provider_accred_no = trim($_POST['provider_accred_no'] ?? '');

  // Logos (full HTTPS recommended for Dompdf)
  $provider_logo_url  = trim($_POST['provider_logo_url']  ?? '');
  $provider_logo2_url = trim($_POST['provider_logo2_url'] ?? '');

  // Contacts
  $provider_email     = trim($_POST['provider_email']     ?? '');
  $provider_phone     = trim($_POST['provider_phone']     ?? '');
  $provider_cell      = trim($_POST['provider_cell']      ?? '');  // NEW
  $provider_website   = trim($_POST['provider_website']   ?? '');

  // Certificate verify base (?code= appended)
  $verify_base_url    = trim($_POST['verify_base_url']    ?? '');

  // Certificate watermark (optional; PNG with transparency is best)
  $watermark_url      = trim($_POST['watermark_url']      ?? '');  // NEW

  // Certificate signatories
  $sig1_name          = trim($_POST['sig1_name']          ?? '');
  $sig1_title         = trim($_POST['sig1_title']         ?? '');
  $sig1_image_url     = trim($_POST['sig1_image_url']     ?? '');
  $sig2_name          = trim($_POST['sig2_name']          ?? '');
  $sig2_title         = trim($_POST['sig2_title']         ?? '');
  $sig2_image_url     = trim($_POST['sig2_image_url']     ?? '');

  // Assessor registration number (printed on certificate)
  $assessor_reg_no    = trim($_POST['assessor_reg_no']    ?? '');  // NEW

  if ($provider_name === '') $err = 'Provider name is required.';

  if (!$err) {
    if ($verify_base_url === '') {
      $verify_base_url = full_url('verify.php?code=');
    }
    // ensure it ends with ?code= or &code=
    if (!preg_match('~[?&]code=$~', $verify_base_url)) {
      $verify_base_url = rtrim($verify_base_url, '&') . (str_contains($verify_base_url, '?') ? '&' : '?') . 'code=';
    }

    // Save settings
    set_setting('provider_name',      $provider_name);
    set_setting('provider_address',   $provider_address);
    set_setting('provider_accred_no', $provider_accred_no);

    set_setting('provider_logo_url',  $provider_logo_url);
    set_setting('provider_logo2_url', $provider_logo2_url);

    set_setting('provider_email',     $provider_email);
    set_setting('provider_phone',     $provider_phone);
    set_setting('provider_cell',      $provider_cell);        // NEW
    set_setting('provider_website',   $provider_website);

    set_setting('verify_base_url',    $verify_base_url);
    set_setting('watermark_url',      $watermark_url);        // NEW

    set_setting('sig1_name',          $sig1_name);
    set_setting('sig1_title',         $sig1_title);
    set_setting('sig1_image_url',     $sig1_image_url);

    set_setting('sig2_name',          $sig2_name);
    set_setting('sig2_title',         $sig2_title);
    set_setting('sig2_image_url',     $sig2_image_url);

    set_setting('assessor_reg_no',    $assessor_reg_no);      // NEW

    $msg = 'Saved.';
  }
}

// Load current values (with safe defaults)
$provider_name      = setting('provider_name','Africa In Training (AIT)');
$provider_address   = setting('provider_address','123 Safety Street, Johannesburg, 2000, South Africa');
$provider_accred_no = setting('provider_accred_no','TETA ACC/123456/2025');

$provider_logo_url  = setting('provider_logo_url',  full_url('assets/img/ait_logo.png'));
$provider_logo2_url = setting('provider_logo2_url', full_url('assets/img/teta_logo.png'));

$provider_email     = setting('provider_email','info@ait.co.za');
$provider_phone     = setting('provider_phone','011 123 4567');
$provider_cell      = setting('provider_cell','082 000 0000'); // NEW
$provider_website   = setting('provider_website','https://ncdigital.co.za');

$verify_base_url    = setting('verify_base_url', full_url('verify.php?code='));
$watermark_url      = setting('watermark_url', $provider_logo_url); // NEW (default to AIT logo)

$sig1_name          = setting('sig1_name','Assessor Name');
$sig1_title         = setting('sig1_title','Registered Assessor (Reg #1234)');
$sig1_image_url     = setting('sig1_image_url', full_url('assets/img/sign1.png'));

$sig2_name          = setting('sig2_name','Training Manager Name');
$sig2_title         = setting('sig2_title','Training Manager');
$sig2_image_url     = setting('sig2_image_url', full_url('assets/img/sign2.png'));

$assessor_reg_no    = setting('assessor_reg_no','TETA/ASS/0000'); // NEW

include __DIR__ . '/templates/header.php';
?>
<h1>Provider Settings</h1>

<?php if ($msg): ?><div class="alert alert-ok"><?= e($msg) ?></div><?php endif; ?>
<?php if ($err): ?><div class="alert alert-error"><?= e($err) ?></div><?php endif; ?>

<form method="post" class="form-card" style="max-width:860px;">
  <?php csrf_field(); ?>

  <!-- Basics -->
  <label class="field">
    <span class="field__label">Provider Name</span>
    <input class="field__input" name="provider_name" value="<?= e($provider_name) ?>" required>
  </label>

  <label class="field">
    <span class="field__label">Provider Address</span>
    <textarea class="field__input" name="provider_address" rows="3"><?= e($provider_address) ?></textarea>
  </label>

  <div class="grid-2">
    <label class="field">
      <span class="field__label">TETA Accreditation Number</span>
      <input class="field__input" name="provider_accred_no" value="<?= e($provider_accred_no) ?>">
    </label>
    <label class="field">
      <span class="field__label">Certificate Verify Base URL</span>
      <input class="field__input" name="verify_base_url" value="<?= e($verify_base_url) ?>" placeholder="https://.../verify.php?code=">
      <div class="small muted">Must end with <code>?code=</code> (we append the certificate code).</div>
    </label>
  </div>

  <!-- Logos -->
  <div class="grid-2">
    <label class="field">
      <span class="field__label">Primary Logo URL (AIT)</span>
      <input class="field__input" name="provider_logo_url" value="<?= e($provider_logo_url) ?>" placeholder="https://.../ait_logo.png">
      <div class="small muted">Use full HTTPS for PDFs (e.g. <?= e(full_url('assets/img/ait_logo.png')) ?>)</div>
    </label>
    <label class="field">
      <span class="field__label">Secondary Logo URL (Authority/TETA)</span>
      <input class="field__input" name="provider_logo2_url" value="<?= e($provider_logo2_url) ?>" placeholder="https://.../teta_logo.png">
    </label>
  </div>

  <!-- Watermark -->
  <label class="field">
    <span class="field__label">Watermark Image URL (PNG with transparency)</span>
    <input class="field__input" name="watermark_url" value="<?= e($watermark_url) ?>" placeholder="https://.../ait_watermark.png">
    <div class="small muted">Recommended: a semi-transparent PNG. We scale it to fit the page.</div>
  </label>

  <!-- Contacts -->
  <div class="grid-2">
    <label class="field">
      <span class="field__label">Contact Email</span>
      <input class="field__input" name="provider_email" value="<?= e($provider_email) ?>" placeholder="info@ait.co.za">
    </label>
    <label class="field">
      <span class="field__label">Contact Phone</span>
      <input class="field__input" name="provider_phone" value="<?= e($provider_phone) ?>" placeholder="+27 11 123 4567">
    </label>
  </div>
  <div class="grid-2">
    <label class="field">
      <span class="field__label">Contact Cell</span>
      <input class="field__input" name="provider_cell" value="<?= e($provider_cell) ?>" placeholder="+27 82 000 0000">
    </label>
    <label class="field">
      <span class="field__label">Website URL</span>
      <input class="field__input" name="provider_website" value="<?= e($provider_website) ?>" placeholder="https://ncdigital.co.za">
    </label>
  </div>

  <!-- Signatories -->
  <div class="panel">
    <div class="panel__body">
      <h3>Certificate Signatories</h3>

      <div class="grid-2">
        <label class="field">
          <span class="field__label">Signature 1 — Name</span>
          <input class="field__input" name="sig1_name" value="<?= e($sig1_name) ?>" placeholder="Assessor Name">
        </label>
        <label class="field">
          <span class="field__label">Signature 1 — Title</span>
          <input class="field__input" name="sig1_title" value="<?= e($sig1_title) ?>" placeholder="Registered Assessor (Reg #...)">
        </label>
      </div>
      <label class="field">
        <span class="field__label">Signature 1 — Image URL (PNG, transparent)</span>
        <input class="field__input" name="sig1_image_url" value="<?= e($sig1_image_url) ?>" placeholder="https://.../sign1.png">
      </label>

      <div class="grid-2">
        <label class="field">
          <span class="field__label">Signature 2 — Name</span>
          <input class="field__input" name="sig2_name" value="<?= e($sig2_name) ?>" placeholder="Training Manager Name">
        </label>
        <label class="field">
          <span class="field__label">Signature 2 — Title</span>
          <input class="field__input" name="sig2_title" value="<?= e($sig2_title) ?>" placeholder="Training Manager">
        </label>
      </div>
      <label class="field">
        <span class="field__label">Signature 2 — Image URL (PNG, transparent)</span>
        <input class="field__input" name="sig2_image_url" value="<?= e($sig2_image_url) ?>" placeholder="https://.../sign2.png">
      </label>

      <div class="grid-2" style="margin-top:10px;">
        <label class="field">
          <span class="field__label">Assessor Registration No</span>
          <input class="field__input" name="assessor_reg_no" value="<?= e($assessor_reg_no) ?>" placeholder="TETA/ASS/12345">
        </label>
      </div>

      <div class="small muted" style="margin-top:6px;">
        Tip: Use transparent PNGs for signatures (upload to <code>/lmis/assets/img/</code> and paste full HTTPS URLs).
      </div>
    </div>
  </div>

  <div class="form__actions">
    <button class="btn btn-primary" type="submit">Save</button>
    <a class="btn btn-outline" href="<?= e(url('dashboard.php')) ?>">Back</a>
  </div>
</form>

<div class="panel"><div class="panel__body">
  <h3>Where these values appear</h3>
  <ul class="bullets">
    <li><strong>Header & Footer:</strong> provider name/logo (site-wide branding).</li>
    <li><strong>Certificates:</strong> provider name & address, TETA accreditation no, logos (AIT & TETA), watermark, signatures, assessor reg, verify link, contact details.</li>
    <li><strong>Verify page:</strong> branding + certificate status for public verification.</li>
  </ul>
</div></div>

<?php include __DIR__ . '/templates/footer.php'; ?>
