<?php
/**
 * templates/certificate_render.php
 * Pure HTML/CSS template (NO DB, NO Dompdf, NO header/footer).
 * Expects: $CERT, $LEARN, $COURSE
 * Optional: $learner_id (if provided by certificate_pdf.php)
 * Reads provider branding from settings.
 */
require_once __DIR__ . '/../lib/helpers.php';
require_once __DIR__ . '/../lib/settings.php';

/* === Provider/settings === */
$provName    = setting('provider_name','Africa In Training (AIT)');
$provAddr    = setting('provider_address','—');
$provAcc     = setting('provider_accred_no','—');
$logoAIT     = setting('provider_logo_url',  full_url('assets/img/ait_logo.png'));
$logoTETA    = setting('provider_logo2_url', '');
$wmUrl       = setting('watermark_url', $logoAIT);
$s1_name     = setting('sig1_name','—');
$s1_title    = setting('sig1_title','—');
$s1_img      = setting('sig1_image_url','');
$s2_name     = setting('sig2_name','—');
$s2_title    = setting('sig2_title','—');
$s2_img      = setting('sig2_image_url','');
$assessorReg = setting('assessor_reg_no','—');

$pMail  = setting('provider_email','—');
$pTel   = setting('provider_phone','—');
$pCell  = setting('provider_cell','—');
$pSite  = setting('provider_website','—');

/* === Learner/course (keep your approved layout) === */
$learnerName = trim($LEARN['name'] ?? '') ?: '—';

/* If caller passed a validated 13-digit ID, use it; otherwise fall back to legacy column to keep layout */
$learnerID   = isset($learner_id) && preg_match('/^\d{13}$/', (string)$learner_id)
             ? $learner_id
             : (trim($LEARN['id_number'] ?? '') ?: '—');

$courseTitle = trim($COURSE['title'] ?? '') ?: '—';
$nqfLevel    = $COURSE['nqf_level'] ?? null;
$credits     = $COURSE['credits'] ?? null;
$courseNo    = trim($COURSE['course_number'] ?? '') ?: '—';
$issued      = trim($CERT['issued_at']  ?? '') ?: '—';
$expires     = trim($CERT['expires_at'] ?? '') ?: '—';

$rawCode     = (string)($CERT['cert_code'] ?? '');
$displayCode = (stripos($rawCode, 'C-AIT-') === 0) ? $rawCode : ('C-AIT-' . $rawCode);

$verifyBase  = rtrim(setting('verify_base_url', full_url('verify.php?code=')));
$verifyUrl   = $verifyBase . urlencode($rawCode);
$qrUrl       = full_url('qr_logo.php?data=' . urlencode($verifyUrl) . '&logo=' . urlencode($logoAIT));

$showWM = (stripos($wmUrl,'http://')===0 || stripos($wmUrl,'https://')===0);

/* If $for_pdf is set by certificate_pdf.php we can tweak tiny spacing if needed */
$compact = !empty($for_pdf);
?>
<style>
  /* Keep the blue frame visible on all sides (right border clipping fix) */
  @page { margin: 12mm 30mm 12mm 14mm; } /* top right bottom left */

  * { box-sizing: border-box; }
  img { max-width: 100%; height: auto; }

  .cert-page  { width: 100%; margin: 0; padding: 0; font-family: Arial, sans-serif; color: #111; }
  .cert-frame {
    position: relative;
    width: 100%;
    border: 8px solid #12459b;   /* AIT blue frame */
    border-radius: 6px;
    padding: 9mm 8mm 7mm 8mm;
    overflow: hidden;
    page-break-inside: avoid;
    font-size: <?= $compact ? '95%' : '100%' ?>;
  }

  /* Watermark: smaller so full mark shows */
  .wm {
    position: absolute;
    bottom: 95mm;
    left: 60%;
    transform: translateX(-50%);
    height: 30%;
    width: auto;
    opacity: 0.06;
    z-index: 0;
  }

  .hdr-table { width: 100%; border-collapse: collapse; position: relative; z-index: 1; margin-bottom: 4mm; }
  .hdr-table td { vertical-align: middle; }
  .logo-ait { height: 18mm; }
  .header-center { text-align: center; }
  .title { font-size: 8mm; margin: 1mm 0 0 0; font-weight: 800; letter-spacing: .25mm; }
  .subtitle { margin: 1.5mm 0 0 0; color: #333; font-size: 3.5mm; }

  .center { text-align: center; position: relative; z-index: 1; }
  .ribbon {
    display: inline-block; background: #a4c95b; color: #000; font-weight: 700;
    padding: 1.5mm 4mm; border-radius: 3mm; margin: 1.5mm 0 1mm 0;
  }
  .certify { margin: 2mm 0 2.5mm 0; font-size: 3.8mm; text-align: center; }

  .label { color:#555; font-size: 3.1mm; margin: 0 0 1mm 0; }
  .value { font-weight: 700; margin: 0; font-size: 4mm; }

  .learner-block { text-align: center; position: relative; z-index: 1; }
  .learner-block .label { display: inline-block; }
  .learner-spacer { height: 2mm; }

  table.triplet { width: 100%; border-collapse: collapse; position: relative; z-index: 1; margin: 2.5mm 0; table-layout: fixed; }
  table.triplet td { width: 33.33%; vertical-align: top; padding-right: 2mm; }

  /* Bottom row (QR | Assessor | Principal | TETA) */
  table.bottom4 {
    width: 100%;
    border-collapse: collapse;
    position: relative; z-index: 1;
    margin-top: 6mm;
    table-layout: fixed;
  }
  table.bottom4 td { vertical-align: middle; padding: 0 4mm; }

  td.col-qr   { width: 32mm; }
  td.col-ass  { width: 50mm; text-align: center; }
  td.col-prn  { width: 50mm; text-align: center; }
  td.col-teta { width: 28mm; text-align: center; }

  .qr-wrap { text-align: left; }
  .qr-wrap img { display: block; height: 26mm; width: 26mm; margin: 0 0 1.5mm 0; }
  .qr-wrap .verify { font-size: 2.6mm; color: #333; line-height: 1.35; word-break: break-all; }

  .sign img {
    display:block; max-height: 14mm; max-width: 100%;
    height: auto; width: auto; margin: 0 auto 1mm auto;
  }
  .sign .name  { font-weight: 700; font-size: 3.4mm; }
  .sign .title { color: #555;     font-size: 3.0mm; }

  .teta-wrap img { display: inline-block; max-width: 100%; max-height: 12mm; width: auto; height: auto; }

  .contact-strip {
    text-align: center;
    margin-top: 5mm;
    padding-top: 2.5mm;
    border-top: 0.3mm solid #d9e1ef;
    font-size: 3.1mm;
    color: #333;
    line-height: 1.45;
    position: relative; z-index: 1;
  }
  .contact-strip .sep { padding: 0 6px; color: #9aa3b2; }
</style>

<div class="cert-page">
  <div class="cert-frame">
    <?php if ($showWM): ?>
      <img class="wm" src="<?= e($wmUrl) ?>" alt="">
    <?php endif; ?>

    <!-- Header -->
    <table class="hdr-table">
      <tr>
        <td style="width:24mm;"><img class="logo-ait" src="<?= e($logoAIT) ?>" alt=""></td>
        <td class="header-center">
          <div class="title">Certificate of Competence</div>
          <div class="subtitle">
            <?= e($provName) ?> &nbsp;•&nbsp; Accreditation No: <strong><?= e($provAcc) ?></strong>
          </div>
        </td>
        <td style="width:24mm;"><!-- spacer --></td>
      </tr>
    </table>

    <div class="center"><span class="ribbon">ACHIEVEMENT</span></div>
    <div class="certify">This is to certify that:</div>

    <!-- Learner block -->
    <div class="learner-block">
      <div class="label">Learner Full Name</div>
      <div class="value"><?= e($learnerName) ?></div>

      <div class="learner-spacer"></div>

      <div class="label">Learner ID Number</div>
      <div class="value"><?= e($learnerID) ?></div>

      <div class="learner-spacer"></div>

      <div>has successfully completed and has been assessed on the following:</div>
    </div>

    <!-- Unit Standard / NQF / Credits -->
    <table class="triplet">
      <tr>
        <td>
          <div class="label">Unit Standard / Course Number</div>
          <div class="value"><?= e($courseNo) ?></div>
        </td>
        <td>
          <div class="label">NQF Level</div>
          <div class="value"><?= ($nqfLevel===null?'—':('L'.(int)$nqfLevel)) ?></div>
        </td>
        <td>
          <div class="label">Credits</div>
          <div class="value"><?= ($credits===null?'—':(int)$credits) ?></div>
        </td>
      </tr>
    </table>

    <!-- Full Course Name -->
    <div style="position:relative; z-index:1;">
      <div class="label">Full Course Name</div>
      <div class="value"><?= e($courseTitle) ?></div>
    </div>

    <!-- Assessor Reg / Issue / Expiry -->
    <table class="triplet">
      <tr>
        <td>
          <div class="label">Assessor Reg No</div>
          <div class="value"><?= e($assessorReg) ?></div>
        </td>
        <td>
          <div class="label">Issue Date</div>
          <div class="value"><?= e($issued) ?></div>
        </td>
        <td>
          <div class="label">Expiry Date</div>
          <div class="value"><?= e($expires) ?></div>
        </td>
      </tr>
    </table>

    <!-- Certificate Number -->
    <div style="position:relative; z-index:1;">
      <div class="label">Certificate Number</div>
      <div class="value"><?= e($displayCode) ?></div>
    </div>

    <!-- Bottom row: QR | Assessor | Principal | TETA -->
    <table class="bottom4">
      <tr>
        <td class="col-qr">
          <div class="qr-wrap">
            <img src="<?= e($qrUrl) ?>" alt="">
            <div class="verify">Verify online:
              <a href="<?= e($verifyUrl) ?>" target="_blank"><?= e($verifyUrl) ?></a>
            </div>
          </div>
        </td>
        <td class="col-ass">
          <div class="sign">
            <?php if ($s1_img): ?><img src="<?= e($s1_img) ?>" alt=""><?php endif; ?>
            <div class="name"><?= e($s1_name) ?></div>
            <div class="title"><?= e($s1_title) ?></div>
          </div>
        </td>
        <td class="col-prn">
          <div class="sign">
            <?php if ($s2_img): ?><img src="<?= e($s2_img) ?>" alt=""><?php endif; ?>
            <div class="name"><?= e($s2_name) ?></div>
            <div class="title"><?= e($s2_title) ?></div>
          </div>
        </td>
        <td class="col-teta">
          <?php if ($logoTETA): ?>
            <div class="teta-wrap"><img src="<?= e($logoTETA) ?>" alt=""></div>
          <?php endif; ?>
        </td>
      </tr>
    </table>

    <!-- Footer: Address & contacts -->
    <div class="contact-strip">
      <div><?= nl2br(e($provAddr)) ?></div>
      <div style="margin-top:2mm;">
        <?php
          $parts = [];
          if ($pMail && $pMail !== '—') $parts[] = 'Email: <a href="mailto:'.e($pMail).'">'.e($pMail).'</a>';
          if ($pSite && $pSite !== '—') $parts[] = 'Web: <a href="'.e($pSite).'" target="_blank">'.e($pSite).'</a>';
          if ($pTel  && $pTel  !== '—') $parts[] = 'Tel: '.e($pTel);
          if ($pCell && $pCell !== '—') $parts[] = 'Cell: '.e($pCell);
          echo implode('<span class="sep">•</span>', $parts);
        ?>
      </div>
    </div>
  </div>
</div>
