<?php
require_once __DIR__ . '/../lib/helpers.php';
require_once __DIR__ . '/../lib/settings.php';

// Defaults first
$pName  = 'Africa In Training (AIT)';
$pAddr  = '';
$pMail  = '';
$pPhone = '';
$pSite  = '';

// Try settings (safe)
try {
  $pName  = setting('provider_name', $pName);
  $pAddr  = setting('provider_address', $pAddr);
  $pMail  = setting('provider_email', $pMail);
  $pPhone = setting('provider_phone', $pPhone);
  $pSite  = setting('provider_website', $pSite);
} catch (Throwable $e) {
  // ignore — keep defaults
}
?>
</main>
</div>

<footer>
  <div class="footer-inner">
    <div class="branch">
      <h4><?= e($pName) ?></h4>
      <?php if ($pAddr): ?><p><?= nl2br(e($pAddr)) ?></p><?php endif; ?>
      <div class="branch-grid">
        <?php if ($pMail): ?><span>📧</span><a href="mailto:<?= e($pMail) ?>"><?= e($pMail) ?></a><?php endif; ?>
        <?php if ($pPhone): ?><span>📞</span><span><?= e($pPhone) ?></span><?php endif; ?>
        <?php if ($pSite):  ?><span>🌐</span><a href="<?= e($pSite) ?>" target="_blank" rel="noopener"><?= e($pSite) ?></a><?php endif; ?>
      </div>
    </div>

    <div class="branch">
      <h4>Mpumalanga</h4>
      <p>36 September Street</br>Middelburg</br> 1050</p>
      <div class="branch-grid"><span>📧</span><span><a href="mailto:info@africaintraining.co.za">info@africaitraining.co.za</a></span></div>
      <div class="branch-grid"><span>📞</span><span><a href="tel:+27786054498"</a>+27 78 605 4498</span></div>
      <div class="branch-grid"><span>🌐</span><span><a href="https://ncdigital.co.za/lmis/" target="_blank" rel="noopener noreferrer">https://ncdigital.co.za/lmis/<a></a></span></div>
    </div>     

    <div class="branch">
      <h4>Limpopo</h4>
      <p>10A Hans Van Rensburg</br>Polokwane</br>0699</p>
      <div class="branch-grid"><span>📧</span><span><a href="mailto:info@africaintraining.co.za">info@africaitraining.co.za</a></span></div>
      <div class="branch-grid"><span>📞</span><span><a href="tel:+27786054498"</a>+27 78 605 4498</span></div>
      <div class="branch-grid"><span>🌐</span><span><a href="https://ncdigital.co.za/lmis/" target="_blank" rel="noopener noreferrer">https://ncdigital.co.za/lmis/<a></a></span></div>
    </div>
  </div>

  <div class="footer-mini-links">
    <a href="<?= e(url('policies/Privacy-Policy.md')) ?>" target="_blank">Privacy Policy</a>
    <span class="sep">•</span>
    <a href="<?= e(url('policies/Code-of-Conduct.md')) ?>" target="_blank">Code of Conduct</a>
  </div>

  <div class="copyright"><a href="https://ncdigital.co.za/lmis" target="_blank" rel="noopener noreferrer">NCDigital</a> © <?= date('Y') ?> LMIS | <?= e($pName) ?></div>
</footer>

</body>
</html>
