<?php
// templates/header.php — clean, DRY, role-aware top bar + ID status badge/banner
ini_set('display_errors',1); error_reporting(E_ALL);

require_once __DIR__ . '/../lib/auth.php';
require_once __DIR__ . '/../lib/helpers.php';
require_once __DIR__ . '/../lib/settings.php';
require_once __DIR__ . '/../lib/demo.php';
require_once __DIR__ . '/../lib/db.php';

$u = current_user();

/* ---------------- ID helpers (ALWAYS read fresh from DB) ---------------- */
function learner_id_status_from_db(int $uid): array {
  try {
    $st = db()->prepare("SELECT national_id_enc, national_id_verified_at FROM users WHERE id=? LIMIT 1");
    $st->execute([$uid]);
    $row = $st->fetch() ?: [];
    $has = !empty($row['national_id_enc']);
    // treat '0000-00-00 00:00:00' as NOT verified
    $ver = !empty($row['national_id_verified_at']) && $row['national_id_verified_at'] !== '0000-00-00 00:00:00';
    return ['has'=>$has, 'verified'=>$ver];
  } catch (Throwable $e) {
    return ['has'=>false, 'verified'=>false];
  }
}

function learner_id_badge_live(array $u): string {
  if (($u['role'] ?? '') !== 'learner') return '';
  $s = learner_id_status_from_db((int)$u['id']);
  if (!$s['has'])      return '<span class="chip" style="background:#fee2e2;color:#7f1d1d;border-color:#fecaca;">ID missing</span>';
  if (!$s['verified']) return '<span class="chip" style="background:#fff7ed;color:#9a3412;border-color:#fed7aa;">ID pending review</span>';
  return '<span class="chip" style="background:#def7ec;color:#03543f;border-color:#bcf0da;">ID verified</span>';
}
/* ----------------------------------------------------------------------- */

/* -------- Central guard for /company/* (keeps code out of each page) --- */
$reqPath = $_SERVER['REQUEST_URI'] ?? '';
if (strpos($reqPath, '/lmis/company/') !== false) {
  if (!$u) { redirect('../login.php'); } // must be logged in
  $isAdmin = can('admin');
  $isCompanyRep = false;

  if (!$isAdmin) {
    try {
      $chk = db()->prepare("SELECT 1 FROM company_user_map WHERE user_id=? AND role='company_rep' LIMIT 1");
      $chk->execute([$u['id']]);
      $isCompanyRep = (bool)$chk->fetch();
    } catch (Throwable $e) { $isCompanyRep = false; } // safe default
  }

  if (!($isAdmin || $isCompanyRep)) {
    http_response_code(403);
    echo "<!doctype html><meta charset='utf-8'><div style='padding:16px;font-family:Arial'>
            <h2>Forbidden</h2>
            <p>You don’t have access to Company pages.</p>
            <p><a href='".e(url('dashboard.php'))."'>Back to dashboard</a></p>
          </div>";
    exit;
  }
}
/* ----------------------------------------------------------------------- */

/* ----------------------- Branding (safe defaults) ----------------------- */
$headerLogo = url('assets/img/ait_logo.png');
$headerName = 'Africa In Training — LMIS';
try {
  $headerLogo = setting('provider_logo_url', $headerLogo);
  $headerName = setting('provider_name', $headerName);
} catch (Throwable $e) { /* keep defaults */ }
/* ----------------------------------------------------------------------- */
?>
<?= demo_banner_html() ?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>AIT LMIS</title>
<link rel="stylesheet" href="<?= e(url('assets/css/style.css')) ?>">
<link rel="icon" href="<?= e(url('assets/img/ait_logo.png')) ?>">
</head>
<body>
<div class="ait-topbar">
  <img src="<?= e($headerLogo) ?>" alt="Logo" class="ait-logo">
  <div style="font-weight:bold;"><?= e($headerName) ?></div>

  <div class="nav" style="margin-left:auto;">
    <?php if ($u): ?>
      <!-- Always visible when logged in -->
      <a href="<?= e(url('dashboard.php')) ?>">Dashboard</a>
      <a href="<?= e(url('courses.php')) ?>">Courses</a>

      <?php if (($u['role'] ?? '') === 'learner'): ?>
        <!-- Learner -->
        <a href="<?= e(url('my_certs.php')) ?>">My Certificates</a>
        <a href="<?= e(url('upload_poe.php')) ?>">Upload POE</a>
        <a href="<?= e(url('ai_tutor.php')) ?>">AI Tutor</a>
      <?php else: ?>
        <!-- Staff (assessor/moderator/admin/TETA) -->
        <a href="<?= e(url('certificates_list.php')) ?>">Certificates</a>

        <?php if (can('grade') || can('admin')): ?>
          <a href="<?= e(url('enroll.php')) ?>">Enroll</a>
          <a href="<?= e(url('record_result.php')) ?>">Record Result</a>
          <a href="<?= e(url('results.php')) ?>">Results</a>
        <?php endif; ?>

        <?php if (can('moderate') || can('admin')): ?>
          <a href="<?= e(url('verify_result.php')) ?>">Verify</a>
          <a href="<?= e(url('moderate_result.php')) ?>">Moderate</a>
        <?php endif; ?>

        <a href="<?= e(url('reports.php')) ?>">Reports</a>
        <?php if (can('admin')): ?>
          <a href="<?= e(url('admin/companies_queue.php')) ?>">Company Approvals</a>
          <a class="chip" href="<?= e(url('settings_provider.php')) ?>">Provider Settings</a>
          <a href="<?= e(url('admin/ids_queue.php')) ?>">ID Queue</a>
        <?php endif; ?>
      <?php endif; ?>

      <!-- Company menu (only if mapped) -->
      <?php
        $myCo = null;
        try {
          $st = db()->prepare("
            SELECT c.* FROM company_user_map m
            JOIN companies c ON c.id=m.company_id
            WHERE m.user_id=? LIMIT 1
          ");
          $st->execute([$u['id']]);
          $myCo = $st->fetch() ?: null;
        } catch (Throwable $e) { $myCo = null; }
      ?>
      <?php if ($myCo): ?>
        <a href="<?= e(url('company/')) ?>">Company</a>
      <?php endif; ?>

      <a href="<?= e(url('profile.php')) ?>">My Profile</a>

      <?php if (($u['role'] ?? '') === 'learner'): ?>
        <span class="small" style="margin-left:6px;vertical-align:middle;">
          <?= learner_id_badge_live($u) ?>
        </span>
      <?php endif; ?>

      <a href="<?= e(url('logout.php')) ?>">Logout</a>
    <?php else: ?>
      <!-- Public -->
      <a href="<?= e(url('login.php')) ?>">Login</a>
      <a href="<?= e(url('register.php')) ?>">Register</a>
    <?php endif; ?>
  </div>
</div>

<div class="container"><hr>

<?php if ($u && ($u['role'] ?? '') === 'learner'): ?>
  <?php
    // Don’t nag on certificate pages
    $uri = $_SERVER['REQUEST_URI'] ?? '';
    $isCertPage = (strpos($uri, '/certificate_view.php') !== false)
               || (strpos($uri, '/certificate_pdf.php')  !== false)
               || (strpos($uri, '/verify.php')           !== false);

    $showNag = false;
    if (!$isCertPage) {
      $s = learner_id_status_from_db((int)$u['id']);
      // only nag if ID is missing (not when pending or verified)
      $showNag = !$s['has'];
    }
  ?>
  <?php if ($showNag): ?>
    <div class="alert alert-error" style="max-width:1100px;margin:10px auto;">
      <strong>Action needed:</strong> Please add your 13-digit South African ID to your
      <a href="<?= e(url('profile.php')) ?>">profile</a>. Certificates cannot be issued without it.
    </div>
  <?php endif; ?>
<?php endif; ?>
