<?php
// Run once, then delete.
// URL: https://ncdigital.co.za/lmis/tools/add_cert_pdf_columns.php
ini_set('display_errors',1); error_reporting(E_ALL);

require_once __DIR__ . '/../lib/auth.php';
require_once __DIR__ . '/../lib/db.php';

require_login();
if (!can('admin')) { http_response_code(403); echo "Admins only."; exit; }

function has_col($t,$c){
  $st = db()->prepare("SHOW COLUMNS FROM `$t` LIKE ?");
  $st->execute([$c]);
  return (bool)$st->fetch();
}
function add_col($sql){
  try { db()->exec($sql); return "✅ ".$sql; }
  catch(Throwable $e){ return "ℹ️ ".$e->getMessage(); }
}

echo "<h2>Add cert PDF columns</h2>";

if (!has_col('certificates','pdf_file')) {
  echo add_col("ALTER TABLE certificates ADD COLUMN pdf_file VARCHAR(255) NULL;");
} else {
  echo "✅ pdf_file already exists<br>";
}

if (!has_col('certificates','pdf_saved_at')) {
  echo "<br>".add_col("ALTER TABLE certificates ADD COLUMN pdf_saved_at DATETIME NULL;");
} else {
  echo "<br>✅ pdf_saved_at already exists";
}

echo "<p>Done. You can delete this file now.</p>";
