<?php
require_once __DIR__ . '/lib/auth.php'; 
// assume $course_id is set (from GET/POST)
$st = db()->prepare("SELECT status FROM enrollments WHERE user_id=? AND course_id=? LIMIT 1");
$st->execute([$u['id'], $course_id]);
$row = $st->fetch();
if (!$row || $row['status'] !== 'approved') {
  http_response_code(403);
  echo "You must be enrolled and approved in this course before uploading POE.";
  exit;
}

require_once __DIR__ . '/lib/helpers.php';
require_once __DIR__ . '/lib/config.php'; require_once __DIR__ . '/lib/db.php';
require_once __DIR__ . '/lib/tracking.php'; require_login(); include __DIR__ . '/templates/header.php';

$msg='';
if($_SERVER['REQUEST_METHOD']==='POST' && isset($_FILES['poe'])){
  if($_FILES['poe']['size']>MAX_UPLOAD){ $msg="File too big."; }
  else{
    $name=basename($_FILES['poe']['name']);
    $dest=POE_DIR.'/'.time().'_'.preg_replace('/[^a-zA-Z0-9._-]/','_',$name);
    if(move_uploaded_file($_FILES['poe']['tmp_name'],$dest)){
      $s=db()->prepare("INSERT INTO submissions(user_id,course_id,filename) VALUES(?,?,?)");
      $s->execute([current_user()['id'], (int)($_POST['course_id']??0), basename($dest)]);
      $msg="Uploaded!"; audit('poe.upload',['file'=>basename($dest)]);
    } else $msg="Upload failed.";
  }
}
$courses=db()->query("SELECT id,title FROM courses ORDER BY title")->fetchAll();
?>
<h2>Upload POE / Assessment</h2>
<?php if($msg): ?><p><?=e($msg)?></p><?php endif; ?>
<form method="post" enctype="multipart/form-data">
  <label>Course:
    <select name="course_id" required>
      <?php foreach($courses as $c): ?><option value="<?=$c['id']?>"><?=e($c['title'])?></option><?php endforeach; ?>
    </select>
  </label><br>
  <label><input type="checkbox" name="auth" required> I declare this is my own work (Authenticity).</label><br>
  <label>File: <input type="file" name="poe" required></label><br>
  <button type="submit">Submit</button>
</form>
<?php include __DIR__ . '/templates/footer.php'; ?>
