<?php
// verify.php — public verifier by ?code=...
require_once __DIR__ . '/lib/db.php';
require_once __DIR__ . '/lib/helpers.php';
require_once __DIR__ . '/lib/settings.php';

$code = trim($_GET['code'] ?? '');
$valid = false; $row = null;

if ($code !== '') {
  try {
    $st = db()->prepare("
      SELECT c.*,
             u.name AS learner_name,
             co.title AS course_title
      FROM certificates c
      LEFT JOIN users u ON u.id=c.user_id
      LEFT JOIN courses co ON co.id=c.course_id
      WHERE c.cert_code=? LIMIT 1
    ");
    $st->execute([$code]);
    $row = $st->fetch();
    $valid = (bool)$row;
  } catch (Throwable $e) {
    $valid = false;
  }
}

$provName = setting('provider_name','Africa In Training (AIT)');
$logo1    = setting('provider_logo_url', url('assets/img/ait_logo.png'));

include __DIR__ . '/templates/header.php';
?>
<h1>Certificate Verification</h1>

<div style="display:flex; align-items:center; gap:10px; margin-bottom:10px;">
  <img src="<?= e($logo1) ?>" alt="Logo" style="height:32px">
  <div><strong><?= e($provName) ?></strong></div>
</div>

<form method="get" class="form-card" style="max-width:520px;">
  <label class="field">
    <span class="field__label">Enter Certificate Code</span>
    <input class="field__input" name="code" value="<?= e($code) ?>" placeholder="e.g., CABC123XYZ">
  </label>
  <div class="form__actions">
    <button class="btn btn-primary">Verify</button>
  </div>
</form>

<?php if ($code !== ''): ?>
  <?php if ($valid): ?>
    <div class="alert alert-ok">✅ Valid certificate.</div>
    <table class="mini">
      <tr><th>Certificate #</th><td><?= e($row['cert_code']) ?></td></tr>
      <tr><th>Learner</th><td><?= e($row['learner_name'] ?? '') ?></td></tr>
      <tr><th>Course</th><td><?= e($row['course_title'] ?? '') ?></td></tr>
      <tr><th>Issued</th><td><?= e($row['issued_at'] ?? '') ?></td></tr>
      <tr><th>Expiry</th><td><?= e($row['expires_at'] ?? '') ?></td></tr>
    </table>
  <?php else: ?>
    <div class="alert alert-error">❌ Invalid or unknown code.</div>
  <?php endif; ?>
<?php endif; ?>

<?php include __DIR__ . '/templates/footer.php'; ?>
