<?php
// /lmis/verify_email.php — marks a user's email as verified via token
ini_set('display_errors',1); error_reporting(E_ALL);

require_once __DIR__ . '/lib/db.php';
require_once __DIR__ . '/lib/helpers.php';
require_once __DIR__ . '/lib/auth.php';

$token = trim($_GET['token'] ?? '');
if ($token==='') { echo "Missing token."; exit; }

$st = db()->prepare("SELECT id FROM users WHERE email_verify_token=? LIMIT 1");
$st->execute([$token]);
$u = $st->fetch();

include __DIR__ . '/templates/header.php';

if (!$u) {
  echo "<h1>Email verification</h1><div class='alert alert-error'>Invalid or already used token.</div>";
} else {
  $up = db()->prepare("UPDATE users SET email_verified_at=NOW(), email_verify_token=NULL WHERE id=?");
  $up->execute([$u['id']]);
  echo "<h1>Email verified</h1><div class='alert alert-ok'>Thank you! Your email is now verified.</div>";
  echo "<p><a class='btn' href='".e(url('dashboard.php'))."'>Go to dashboard</a></p>";
}

include __DIR__ . '/templates/footer.php';
